﻿using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.OnDemand
{
    /// <summary>
    /// Generate Patient/Provider PIN Processing step.
    /// </summary>
    public class GeneratePinsStep : FilterBase<VmrOnDemandCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VmrOnDemandCreateStateObject state)
        {
            state.PatientPin = string.Format("{0}#", RandomDigits.GetRandomDigitString(state.PatientPinLength));
            state.ProviderPin = string.Format("{0}#", RandomDigits.GetRandomDigitString(state.ProviderPinLength));
        }
    }
}